% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_coverage.R
\name{test_coverage}
\alias{test_coverage}
\title{Test coverage of package}
\usage{
test_coverage(from_tags = TRUE, from_desc = TRUE)
}
\arguments{
\item{from_tags}{\code{logical} scalar. Checks the files if your test directory for
testthis tags. Specifically, if you have the comment \code{#* @testing myfunction}
in any of your test files, myfunction will be marked as tested.}

\item{from_desc}{\code{logical} scalar. Checks the \code{desc} argument
\code{test_that(...)} of the tests in your test directory for functions
names. E.g. if you have a test file that contains
\code{test_that("myfunction works", {...})}, myfunction will be marked as
tested.}
}
\value{
A \code{Test_coverage} object. This is a \code{data.frame} containing the
following columns:
\itemize{
\item fun: Name of the function
\item exp: Is function is exported?
\item s3: Is function an S3 method?
\item tested: Do unit tests exist for function?
\item ignore: Is function listed in \file{tests/testthat/_testignore}?
}
}
\description{
This determines the test coverage of the target package based on the \code{desc}
argument of \code{test_that()} calls. If you require a more comprehensive analysis
of test coverage, try the package \strong{covr} instead.
}
\details{
\code{test_coverage} looks in \code{.covrignore} for functions that should be ignored
for coverage analysis (see \code{\link[usethis:use_covr_ignore]{usethis::use_covr_ignore()}})
}
\examples{

\dontrun{
x <- test_coverage()
as.data.frame(x)
}

}
