% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-files.R
\name{test_dir}
\alias{test_dir}
\title{Run all tests in a directory}
\usage{
test_dir(
  path,
  filter = NULL,
  reporter = NULL,
  env = NULL,
  ...,
  load_helpers = TRUE,
  stop_on_failure = TRUE,
  stop_on_warning = FALSE,
  wrap = lifecycle::deprecated(),
  package = NULL,
  load_package = c("none", "installed", "source")
)
}
\arguments{
\item{path}{Path to directory containing tests.}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed. Matching is performed on the file
name after it's stripped of \code{"test-"} and \code{".R"}.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{env}{Environment in which to execute the tests. Expert use only.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}} to control filtering.}

\item{load_helpers}{Source helper files before running the tests?
See \code{\link[=source_test_helpers]{source_test_helpers()}} for more details.}

\item{stop_on_failure}{If \code{TRUE}, throw an error if any tests fail.}

\item{stop_on_warning}{If \code{TRUE}, throw an error if any tests generate
warnings.}

\item{wrap}{DEPRECATED}

\item{package}{If these tests belong to a package, the name of the package.}

\item{load_package}{Strategy to use for load package code:
\itemize{
\item "none", the default, doesn't load the package.
\item "installed", uses \code{\link[=library]{library()}} to load an installed package.
\item "source", uses \code{\link[pkgload:load_all]{pkgload::load_all()}} to a source package.
}}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
This function is the low-level workhorse that powers \code{\link[=test_local]{test_local()}} and
\code{\link[=test_package]{test_package()}}. Generally, you should not call this function directly.
In particular, you are responsible for ensuring that the functions to test
are available in the test \code{env} (e.g. via \code{load_package}).
}
\section{Special files}{

There are two types of \code{.R} file that have special behaviour:
\itemize{
\item Test files start with \code{test} and are executed in alphabetical order.
\item Setup files start with \code{setup} and are executed before tests. If
clean up is needed after all tests have been run, you can use
\code{withr::defer(clean_up(), teardown_env())}. See \code{vignette("test-fixtures")}
for more details.
}

There are two other types of special file that we no longer recommend using:
\itemize{
\item Helper files start with \code{helper} and are executed before tests are
run. They're also loaded by \code{devtools::load_all()}, so there's no
real point to them and you should just put your helper code in \verb{R/}.
\item Teardown files start with \code{teardown} and are executed after the tests
are run. Now we recommend interleave setup and cleanup code in \verb{setup-}
files, making it easier to check that you automatically clean up every
mess that you make.
}

All other files are ignored by testthat.
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment that inherits from the
package's namespace environment, so that tests can access internal functions
and objects.
}

\keyword{internal}
