% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{with_mock}
\alias{with_mock}
\alias{local_mock}
\title{Mock functions in a package.}
\usage{
with_mock(..., .env = topenv())

local_mock(..., .env = topenv(), .local_envir = parent.frame())
}
\arguments{
\item{...}{named parameters redefine mocked functions, unnamed parameters
will be evaluated after mocking the functions}

\item{.env}{the environment in which to patch the functions,
defaults to the top-level environment.  A character is interpreted as
package name.}

\item{.local_env}{Environment in which to add exit hander.
For expert use only.}
}
\value{
The result of the last unnamed parameter
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{with_mock()} and \code{local_mock()} are superseded in favour of the more
rigorous techniques found in the \href{https://krlmlr.github.io/mockr/}{mockr}
and \href{https://github.com/r-lib/mockery#mockery}{mockery} packages.

Mocking allows you to temporary replace the implementation of functions
within a package, which useful for testing code that relies on functions
that are slow, have unintended side effects or access resources that may
not be available when testing.

This works by using some C code to temporarily modify the mocked function
\emph{in place}. On exit, all functions are restored to their previous state.
This is somewhat abusive of R's internals so use with care. In particular,
functions in base packages cannot be mocked; to work aroud you'll need to
make a wrapper function in your own package..
}
\section{3rd edition}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{with_mock()} and \code{local_mock()} are deprecated in the third edition.
}

\references{
Suraj Gupta (2012): \href{http://blog.obeautifulcode.com/R/How-R-Searches-And-Finds-Stuff/}{How R Searches And Finds Stuff}
}
\keyword{internal}
