% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inheritance.R
\name{class-tests}
\alias{class-tests}
\alias{all_inherit}
\alias{are}
\alias{is_exactly}
\alias{all_are_exactly}
\title{Enhanced Class Tests}
\usage{
all_inherit(lst, class, label = NULL)

are(lst, class)

is_exactly(object, class)

all_are_exactly(lst, class, label = NULL)
}
\arguments{
\item{lst}{A list of objects to test}

\item{class}{The class object is to be, or classes it is allowed to be.}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{object}{An object to test}
}
\description{
These tests allow for mapped and enhanced tests regarding class.
}
\section{Functions}{
\itemize{
\item \code{all_inherit}: Check if all elements of a list are or inherit from the given class.
Uses \code{\link[base:inherits]{base::inherits()}} to check inheritance.

\item \code{are}: \link[methods:is]{methods::is} mapped over a vector.
Similar to \code{all_inherit} but uses \code{\link[methods:is]{methods::is()}} for test.
This manifests in S4 Virtual classes such as the 'ANY' class

\item \code{is_exactly}: Test that an object is exactly a class; excludes inheritance.

\item \code{all_are_exactly}: Version of \code{is_exactly} for all elements of a list.
}}

\examples{
lst <- list(1L, 2, TRUE)

# all_inherit uses `inherits`
all_inherit(lst, 'numeric')
all_inherit(lst, 'integer')
all_inherit(lst, 'ANY')

# are uses `is` so gets different results.
are(lst, "numeric")
are(lst, "integer")
are(lst, "ANY")

# is_exactly the class must match exactly
is_exactly(1L, "integer")
# no inheritance allowed
is_exactly(1L, "numeric")
}
\seealso{
Other class: \code{\link{class-expectations}}
}
\concept{class}
