% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testcorr.R
\name{rcorr.test}
\alias{rcorr.test}
\title{Testing zero Pearson correlation}
\usage{
rcorr.test(x, plot = TRUE, table = TRUE, var.names = NULL,
           scale.font = 1)
}
\arguments{
\item{x}{A numeric matrix or a multivariate numeric time series object or a data frame.}

\item{plot}{Logical. If TRUE the sample Pearson correlations and the p-values for significance are plotted. Default is TRUE.}

\item{table}{Logical. If TRUE the sample Pearson correlations and the p-values for significance are printed out. Default is TRUE.}

\item{var.names}{NULL or a character string specifying the variable names. If NULL and x has names, the names of x are used. If NULL and x has no names, the string c("x[1]","x[2]",...) is used. Default is NULL.}

\item{scale.font}{A positive number indicating the scaling of the font size in the plots. Default is 1.}
}
\value{
An object of class "rcorr.test", which is a list with the following components:
\item{pc}{The sample Pearson correlations.}
\item{pv}{The p-values for the \eqn{\widetilde{t}}{t-tilde} test statistics.}
}
\description{
The function rcorr.test computes the test statistics for examining the null hypothesis
of zero Pearson correlation for multivariate series in Dalla, Giraitis and Phillips (2020).
}
\details{
The p-value of the robust \eqn{\widetilde{t}}{t-tilde} statistic is for testing the null hypothesis \eqn{H_0:\rho_{i,j}=0}{H[0]:\rho[i,j]=0},
where \eqn{\rho_{i,j}}{\rho[i,j]} denotes the correlation of \eqn{x_{i}}{x[i]} and \eqn{x_{j}}{x[j]}.
}
\note{
Missing values are not allowed.
}
\examples{
x <- matrix(rnorm(400),100)
rcorr.test(x)
}
\references{
Dalla, V., Giraitis, L. and Phillips, P. C. B. (2020). "Robust Tests for White Noise and Cross-Correlation". Cowles Foundation, Discussion Paper No. 2194, \url{https://cowles.yale.edu/sites/default/files/files/pub/d21/d2194-r.pdf}.
}
\author{
Violetta Dalla, Liudas Giraitis and Peter C. B. Phillips
}
