% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{Edge3}
\alias{Edge3}
\title{R6 class representing an edge in dimension 3.}
\description{
An edge is given by two vertices in the 3D space,
  named \code{A} and \code{B}. This is for example an edge of a Voronoï cell
  of a 3D Delaunay tessellation.
}
\examples{

## ------------------------------------------------
## Method `Edge3$new`
## ------------------------------------------------

edge <- Edge3$new(c(1, 1, 1), c(1, 2, 3))
edge
edge$A
edge$A <- c(1, 0, 0)
edge

## ------------------------------------------------
## Method `Edge3$print`
## ------------------------------------------------

Edge3$new(c(2, 0, 0), c(3, -1, 4))

## ------------------------------------------------
## Method `Edge3$plot`
## ------------------------------------------------

library(tessellation)
d <- delaunay(centricCuboctahedron())
v <- voronoi(d)
cell13 <- v[[13]] # the point (0, 0, 0), at the center
isBoundedCell(cell13) # TRUE
library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
invisible(lapply(cell13[["cell"]], function(edge) edge$plot()))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the vertex \code{A}}

\item{\code{B}}{get or set the vertex \code{B}}

\item{\code{idA}}{get or set the id of vertex \code{A}}

\item{\code{idB}}{get or set the id of vertex \code{B}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Edge3$new()}}
\item \href{#method-print}{\code{Edge3$print()}}
\item \href{#method-plot}{\code{Edge3$plot()}}
\item \href{#method-stack}{\code{Edge3$stack()}}
\item \href{#method-clone}{\code{Edge3$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Edge3} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge3$new(A, B, idA, idB)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A}}{the vertex \code{A}}

\item{\code{B}}{the vertex \code{B}}

\item{\code{idA}}{the id of vertex \code{A}, an integer; can be missing}

\item{\code{idB}}{the id of vertex \code{B}, an integer; can be missing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Edge3} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{edge <- Edge3$new(c(1, 1, 1), c(1, 2, 3))
edge
edge$A
edge$A <- c(1, 0, 0)
edge
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{Edge3} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge3$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Edge3$new(c(2, 0, 0), c(3, -1, 4))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Plot an \code{Edge3} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge3$plot(edgeAsTube = FALSE, tubeRadius, tubeColor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{edgeAsTube}}{Boolean, whether to plot the edge as a tube}

\item{\code{tubeRadius}}{the radius of the tube}

\item{\code{tubeColor}}{the color of the tube}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(tessellation)
d <- delaunay(centricCuboctahedron())
v <- voronoi(d)
cell13 <- v[[13]] # the point (0, 0, 0), at the center
isBoundedCell(cell13) # TRUE
library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
invisible(lapply(cell13[["cell"]], function(edge) edge$plot()))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stack"></a>}}
\if{latex}{\out{\hypertarget{method-stack}{}}}
\subsection{Method \code{stack()}}{
Stack the two vertices of the edge (this is for internal
purpose).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge3$stack()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Edge3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
