% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cols_by_groups.R
\name{groups_list_to_df}
\alias{groups_list_to_df}
\title{Convert list of groups to a data frame}
\usage{
groups_list_to_df(groups_list)
}
\arguments{
\item{groups_list}{(named \code{list} of \code{character})\cr specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}
}
\value{
A \code{tibble} in the required format.
}
\description{
This converts a list of group levels into a data frame format which is expected by \code{\link[rtables:add_overall_level]{rtables::add_combo_levels()}}.
}
\examples{
grade_groups <- list(
  "Any Grade (\%)" = c("1", "2", "3", "4", "5"),
  "Grade 3-4 (\%)" = c("3", "4"),
  "Grade 5 (\%)" = "5"
)
groups_list_to_df(grade_groups)

}
