% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_cox_regression.R
\name{h_cox_regression}
\alias{h_cox_regression}
\alias{h_coxreg_univar_formulas}
\alias{h_coxreg_multivar_formula}
\alias{h_coxreg_univar_extract}
\alias{h_coxreg_multivar_extract}
\title{Helper Functions for Cox Proportional Hazards Regression}
\usage{
h_coxreg_univar_formulas(variables, interaction = FALSE)

h_coxreg_multivar_formula(variables)

h_coxreg_univar_extract(effect, covar, data, mod, control = control_coxreg())

h_coxreg_multivar_extract(var, data, mod, control = control_coxreg())
}
\arguments{
\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{interaction}{(\code{flag})\cr if \code{TRUE}, the model includes the interaction between the studied
treatment and candidate covariate. Note that for univariate models without treatment arm, and
multivariate models, no interaction can be used so that this needs to be \code{FALSE}.}

\item{effect}{(\code{string})\cr the treatment variable.}

\item{covar}{(\code{string})\cr the name of the covariate in the model.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{mod}{(\code{coxph})\cr Cox regression model fitted by \code{\link[survival:coxph]{survival::coxph()}}.}

\item{control}{(\code{list})\cr a list of controls as returned by \code{\link[=control_coxreg]{control_coxreg()}}.}

\item{var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}
}
\value{
\itemize{
\item \code{h_coxreg_univar_formulas()} returns a \code{character} vector coercible into formulas (e.g \code{\link[stats:formula]{stats::as.formula()}}).
}

\itemize{
\item \code{h_coxreg_multivar_formula()} returns a \code{string} coercible into a formula (e.g \code{\link[stats:formula]{stats::as.formula()}}).
}

\itemize{
\item \code{h_coxreg_univar_extract()} returns a \code{data.frame} with variables \code{effect}, \code{term}, \code{term_label}, \code{level},
\code{n}, \code{hr}, \code{lcl}, \code{ucl}, and \code{pval}.
}

\itemize{
\item \code{h_coxreg_multivar_extract()} returns a \code{data.frame} with variables \code{pval}, \code{hr}, \code{lcl}, \code{ucl}, \code{level},
\code{n}, \code{term}, and \code{term_label}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper functions used in \code{\link[=fit_coxreg_univar]{fit_coxreg_univar()}} and \code{\link[=fit_coxreg_multivar]{fit_coxreg_multivar()}}.
}
\section{Functions}{
\itemize{
\item \code{h_coxreg_univar_formulas()}: Helper for Cox regression formula. Creates a list of formulas. It is used
internally by \code{\link[=fit_coxreg_univar]{fit_coxreg_univar()}} for the comparison of univariate Cox regression models.

\item \code{h_coxreg_multivar_formula()}: Helper for multivariate Cox regression formula. Creates a formulas
string. It is used internally by \code{\link[=fit_coxreg_multivar]{fit_coxreg_multivar()}} for the comparison of multivariate Cox
regression models. Interactions will not be included in multivariate Cox regression model.

\item \code{h_coxreg_univar_extract()}: Utility function to help tabulate the result of
a univariate Cox regression model.

\item \code{h_coxreg_multivar_extract()}: Tabulation of multivariate Cox regressions. Utility function to help
tabulate the result of a multivariate Cox regression model for a treatment/covariate variable.

}}
\examples{
# `h_coxreg_univar_formulas`

## Simple formulas.
h_coxreg_univar_formulas(
  variables = list(
    time = "time", event = "status", arm = "armcd", covariates = c("X", "y")
  )
)

## Addition of an optional strata.
h_coxreg_univar_formulas(
  variables = list(
    time = "time", event = "status", arm = "armcd", covariates = c("X", "y"),
    strata = "SITE"
  )
)

## Inclusion of the interaction term.
h_coxreg_univar_formulas(
  variables = list(
    time = "time", event = "status", arm = "armcd", covariates = c("X", "y"),
    strata = "SITE"
  ),
  interaction = TRUE
)

## Only covariates fitted in separate models.
h_coxreg_univar_formulas(
  variables = list(
    time = "time", event = "status", covariates = c("X", "y")
  )
)

# `h_coxreg_multivar_formula`

h_coxreg_multivar_formula(
  variables = list(
    time = "AVAL", event = "event", arm = "ARMCD", covariates = c("RACE", "AGE")
  )
)

# Addition of an optional strata.
h_coxreg_multivar_formula(
  variables = list(
    time = "AVAL", event = "event", arm = "ARMCD", covariates = c("RACE", "AGE"),
    strata = "SITE"
  )
)

# Example without treatment arm.
h_coxreg_multivar_formula(
  variables = list(
    time = "AVAL", event = "event", covariates = c("RACE", "AGE"),
    strata = "SITE"
  )
)

library(survival)

dta_simple <- data.frame(
  time = c(5, 5, 10, 10, 5, 5, 10, 10),
  status = c(0, 0, 1, 0, 0, 1, 1, 1),
  armcd = factor(LETTERS[c(1, 1, 1, 1, 2, 2, 2, 2)], levels = c("A", "B")),
  var1 = c(45, 55, 65, 75, 55, 65, 85, 75),
  var2 = c("F", "M", "F", "M", "F", "M", "F", "U")
)
mod <- coxph(Surv(time, status) ~ armcd + var1, data = dta_simple)
result <- h_coxreg_univar_extract(
  effect = "armcd", covar = "armcd", mod = mod, data = dta_simple
)
result

mod <- coxph(Surv(time, status) ~ armcd + var1, data = dta_simple)
result <- h_coxreg_multivar_extract(
  var = "var1", mod = mod, data = dta_simple
)
result

}
\seealso{
\link{cox_regression}
}
