% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_proportion.R
\name{strata_normal_quantile}
\alias{strata_normal_quantile}
\title{Helper Function for the Estimation of Stratified Quantiles}
\usage{
strata_normal_quantile(vars, weights, conf_level)
}
\arguments{
\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{weights}{(\code{numeric} or \code{NULL})\cr weights for each level of the strata. If \code{NULL}, they are
estimated using the iterative algorithm proposed in \insertCite{Yan2010-jt;textual}{tern} that
minimizes the weighted squared length of the confidence interval.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
Stratified quantile.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function wraps the estimation of stratified percentiles when we assume
the approximation for large numbers. This is necessary only in the case
proportions for each strata are unequal.
}
\examples{
strata_data <- table(data.frame(
  "f1" = sample(c(TRUE, FALSE), 100, TRUE),
  "f2" = sample(c("x", "y", "z"), 100, TRUE),
  stringsAsFactors = TRUE
))
ns <- colSums(strata_data)
ests <- strata_data["TRUE", ] / ns
vars <- ests * (1 - ests) / ns
weights <- rep(1 / length(ns), length(ns))
strata_normal_quantile(vars, weights, 0.95)

}
\seealso{
\code{\link[=prop_strat_wilson]{prop_strat_wilson()}}
}
