% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{build_formula}
\alias{build_formula}
\title{Building Model Formula}
\usage{
build_formula(
  vars,
  cor_struct = c("unstructured", "toeplitz", "heterogeneous toeplitz", "ante-dependence",
    "heterogeneous ante-dependence", "auto-regressive", "heterogeneous auto-regressive",
    "compound symmetry", "heterogeneous compound symmetry")
)
}
\arguments{
\item{vars}{(\code{list})\cr variables to use in the model.}

\item{cor_struct}{(\code{string})\cr specify the covariance structure to use.}
}
\value{
Formula to use in \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This builds the model formula which is used inside \code{\link[=fit_mmrm]{fit_mmrm()}} and provided
to \code{\link[mmrm:mmrm]{mmrm::mmrm()}} internally. It can be instructive to look at the resulting
formula directly sometimes.
}
\examples{
vars <- list(
  response = "AVAL", covariates = c("RACE", "SEX"),
  id = "USUBJID", arm = "ARMCD", visit = "AVISIT"
)
build_formula(vars, "auto-regressive")
build_formula(vars)
}
