% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{showallcomp}
\alias{showallcomp}
\title{Retrieve all the comparison names from the experiment table}
\usage{
showallcomp(expdf, verbose = FALSE)
}
\arguments{
\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{FALSE}.}
}
\value{
If less than three conditions, nothing. Otherwise a character vector of all
comparisons.
}
\description{
The `showallcomp` function build the string of all comparisons possible
using the condition column of a provided experiment table.
}
\examples{
# Create a valid experiment table
exptab <- data.frame(
  condition = c("cond1", "cond2", "cond3"),
  replicate = c(1, 1, 1),
  direction = c("forward", "reverse", "forward"),
  strand = c("plus", "minus", "plus"),
  path = c("toto/", "toto/", "toto/"))
checkexptab(exptab)
showallcomp(exptab)

}
