% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbm_clustering.R
\name{tbm_clustering}
\alias{tbm_clustering}
\title{Perform tensor clustering via tensor block model (TBM)}
\usage{
tbm_clustering(
  x,
  k,
  r,
  l,
  lambda = 0,
  max.iter = 1000,
  threshold = 1e-10,
  sim.times = 1,
  trace = FALSE,
  Cs.init = NULL,
  Ds.init = NULL,
  Es.init = NULL,
  method = "L0"
)
}
\arguments{
\item{x}{an order-3 data tensor}

\item{k}{an positive integer, the numbers of clusters at mode 1}

\item{r}{an positive integer, the numbers of clusters at mode 2}

\item{l}{an positive integer, the numbers of clusters at mode 3}

\item{lambda}{a numeric value, regularization coefficient}

\item{max.iter}{a positive integer, the maximum numbers of iteration}

\item{threshold}{a positive small numeric value for convergence threshold}

\item{sim.times}{the number of simulation replicates when performing clustering}

\item{trace}{logic value, print result per each iteration if TRUE}

\item{Cs.init}{vector or NULL, initial cluster label assignment at mode 1}

\item{Ds.init}{vector or NULL, initial cluster label assignment at mode 2}

\item{Es.init}{vector or NULL, initial cluster label assignment at mode 3}

\item{method}{two options: "L0", "L1". "L0" indicates L0 penalty, and "L1" indicates Lasso penalty}
}
\value{
a list  


\code{judgeX} estimated underlying signal tensor

               \code{Cs} clustering result at mode 1
               
               \code{Ds} clustering result at mode 2
               
               \code{Es} clustering result at mode 3 
               
               \code{mus} estimated block means
}
\description{
Perform tensor clustering via tensor block model (TBM) method.
}
\examples{
x = get_data(20,20,20,2,2,2)$x
tbm_clustering(x,2,2,2)

}
\references{
{M. Wang and Y. Zeng, "Multiway clustering via tensoe block models". Advances in Neural Information Processing System 32 (NeurIPS), 715-725, 2019.}
}
\author{
Yuchen Zeng \email{yzeng58@wisc.edu}
}
