% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoInput.R
\name{loadCLS}
\alias{loadCLS}
\title{Load a categorical or continuous cls formatted file.}
\usage{
loadCLS(target, sampleNames)
}
\arguments{
\item{target}{a string indicating the location of the .cls file. loadCLS will automatically determine whether the specified file is categorical or continuous.}

\item{sampleNames}{a list of sample names that correspond to each each entry in the .cls file.}
}
\value{
a list indexed by sample id containing the specified categorical or continuous variable.
}
\description{
\code{loadCLS} loads a categorical or continuous cls formated file.  Both file formats are described at \href{http://www.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}{the BROAD site}.
}
\examples{
# The .cls format does not include sample names, so it is necesary to have some already.
# In this case, we get them from the .gct file
sampleNames = names(loadGCT(file.path(path.package("tempoR"),"gse32472Example.gct")))

# Example continouous and categorical .cls files are included in the package
exampleAgesPath = file.path(path.package("tempoR"),"gse32472Example.age.cls")
exampleAges = loadCLS(exampleAgesPath, sampleNames)

exampleClassesPath = file.path(path.package("tempoR"),"gse32472Example.phen.cls")
exampleClasses = loadCLS(exampleClassesPath, sampleNames)
}
