% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{model_shmax}
\alias{model_shmax}
\title{Theoretical Direction of Maximum Horizontal Stress in the
geographical reference system.}
\usage{
model_shmax(df, euler)
}
\arguments{
\item{df}{\code{data.frame} containing the coordinates of the point(s)
(\code{lat}, \code{lon}).}

\item{euler}{\code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler pole}
}
\value{
\code{data.frame}
\describe{
\item{gc}{Azimuth of modeled \eqn{\sigma_{Hmax}}{SHmax} following
great circles}
\item{sc}{Small circles}
\item{ld.cw}{Clockwise loxodromes}
\item{ld.ccw}{Counter-clockwise loxodromes}
}
}
\description{
Models the direction of maximum horizontal stress
\eqn{\sigma_{Hmax}}{SHmax} along great circles, small circles, and
loxodromes at a given point or points according to the relative plate motion
in the geographical coordinate reference system.
}
\details{
\eqn{\sigma_{Hmax}}{SHmax} following \emph{great circles} is the
(initial) bearing between the given point and the pole of relative plate
motion. \eqn{\sigma_{Hmax}}{SHmax} along \emph{small circles}, clockwise, and
counter-clockwise \emph{loxodromes} is 90\eqn{^{\circ}}{ degree},
+45\eqn{^{\circ}}{ degree}, and 135\eqn{^{\circ}}{ degree}
(-45\eqn{^{\circ}}{ degree}) to this great circle bearing, respectively.
}
\examples{
data("nuvel1")
# North America relative to Pacific plate:
euler <- subset(nuvel1, nuvel1$plate.rot == "na")

# the point where we mant to model the SHmax direction:
point <- data.frame(lat = 45, lon = 20)

model_shmax(point, euler)
}
\references{
Stephan, T., Enkelmann, E., and Kroner, U. "Analyzing the
horizontal orientation of the crustal stress adjacent to plate boundaries".
\emph{Sci Rep} 13. 15590 (2023). \doi{10.1038/s41598-023-42433-2}.
}
\seealso{
\code{\link[=deviation_shmax]{deviation_shmax()}} to compute the deviation of the modeled direction
from the observed direction of \eqn{\sigma_{Hmax}}{SHmax}.
\code{\link[=PoR_shmax]{PoR_shmax()}} to calculate the azimuth of \eqn{\sigma_{Hmax}}{SHmax}
in the pole of rotation reference system.
}
\author{
Tobias Stephan
}
