% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{second_central_moment}
\alias{second_central_moment}
\title{Second Central Momentum}
\usage{
second_central_moment(x, w = NULL, axial = TRUE, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
list containing
\describe{
\item{\code{skewness}}{second central sine momentum, i.e. the skewness}
\item{\code{std_skewness}}{standardized skewness}
\item{\code{kurtosis}}{second central cosine momentum, i.e. the kurtosis}
\item{\code{std_kurtosis}}{standardized kurtosis}
}
}
\description{
Measures the skewness (a measure of the asymmetry of the probability
distribution) and the kurtosis (measure of the "tailedness" of the probability
distribution). Standardized versions are the skewness and kurtosis normalized
by the mean resultant length, Mardia 1972).
}
\details{
Negative values of skewness indicate skewed data in counterclockwise
direction.

Large kurtosis values indicate tailed, values close to \code{0} indicate packed
data.
}
\examples{
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
second_central_moment(sa.por$azi.PoR)
second_central_moment(sa.por$azi.PoR, w = 1 / san_andreas$unc)
}
