#' Plate Boundaries on the Earth
#'
#' Global set of present plate boundaries on the Earth based on PB2002 model by
#' Bird (2003). Contains the plate boundary displacement types such as inward,
#' outward, or tangentially displacement.
#'
#' @docType data
#'
#' @usage data('plates')
#'
#' @format An object of class `sf`
#'
#' @references  Bird, P. (2003), An updated digital model of plate boundaries,
#' *Geochem. Geophys. Geosyst.*, **4**, 1027, doi: 10.1029/2001GC000252, 3.
#'
#' @keywords datasets
#'
#' @examples
#' data("plates")
#' head("plates")
"plates"


#' #' Plate Boundaries on the Earth (GSRM 2.1)
#' #'
#' #' Global set of present plate boundaries on the Earth based on GSRM2.1 model by
#' #' Kreemer et al (2014).
#' #'
#' #' @docType data
#' #'
#' #' @usage data('gsrm2_plates')
#' #'
#' #' @format An object of class `sf`
#' #'
#' #' @references Kreemer, C., Blewitt, G., & Klein, E. C. (2014). A geodetic plate
#' #' motion and Global Strain Rate Model. *Geochemistry, Geophysics, Geosystems*,
#' #' **15**(10), 3849–3889. doi: 10.1002/2014GC005407.
#' #'
#' #' @keywords datasets
#' #'
#' #' @examples
#' #' data("gsrm2_plates")
#' #' head("gsrm2_plates")
#' "gsrm2_plates"
