% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdata.R
\name{as_tdata}
\alias{as_tdata}
\title{Downgrade \code{teal_data} objects in modules for compatibility}
\usage{
as_tdata(x)
}
\arguments{
\item{x}{data object, either \code{tdata} or \code{teal_data}, the latter possibly in a reactive expression}
}
\value{
Object of class \code{tdata}.
}
\description{
Convert \code{teal_data} to \code{tdata} in \code{teal} modules.
}
\details{
Recent changes in \code{teal} cause modules to fail because modules expect a \code{tdata} object
to be passed to the \code{data} argument but instead they receive a \code{teal_data} object,
which is additionally wrapped in a reactive expression in the server functions.
In order to easily adapt such modules without a proper refactor,
use this function to downgrade the \code{data} argument.
}
\examples{
td <- teal_data()
td <- within(td, iris <- iris) \%>\% within(mtcars <- mtcars)
td
as_tdata(td)
as_tdata(reactive(td))

}
