% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_pp_medical_history.R
\name{tm_t_pp_medical_history}
\alias{tm_t_pp_medical_history}
\title{teal Module: Patient Profile Medical History}
\usage{
tm_t_pp_medical_history(
  label,
  dataname = "ADMH",
  parentname = "ADSL",
  patient_col = "USUBJID",
  mhterm = NULL,
  mhbodsys = NULL,
  mhdistat = NULL,
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{mhterm}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{MHTERM} variable from \code{dataname}.}

\item{mhbodsys}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{MHBODSYS} variable from \code{dataname}.}

\item{mhdistat}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{MHDISTAT} variable from \code{dataname}.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile medical history report using ADaM datasets.
}
\examples{
ADSL <- tmc_ex_adsl
ADMH <- tmc_ex_admh

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADMH = ADMH,
    code = "
      ADSL <- tmc_ex_adsl
      ADMH <- tmc_ex_admh
    "
  ),
  modules = modules(
    tm_t_pp_medical_history(
      label = "Medical History",
      dataname = "ADMH",
      parentname = "ADSL",
      patient_col = "USUBJID",
      mhterm = choices_selected(
        choices = variable_choices(ADMH, c("MHTERM")),
        selected = "MHTERM"
      ),
      mhbodsys = choices_selected(
        choices = variable_choices(ADMH, "MHBODSYS"),
        selected = "MHBODSYS"
      ),
      mhdistat = choices_selected(
        choices = variable_choices(ADMH, "MHDISTAT"),
        selected = "MHDISTAT"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
