% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_ancova.R
\name{tm_t_ancova}
\alias{tm_t_ancova}
\title{teal Module: ANCOVA Summary}
\usage{
tm_t_ancova(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  aval_var,
  cov_var,
  include_interact = FALSE,
  interact_var = NULL,
  interact_y = FALSE,
  avisit,
  paramcd,
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{arm_ref_comp}{optional, (\code{list})\cr If specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{cov_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the covariates variables.}

\item{include_interact}{(\code{logical})\cr whether an interaction term should be included in the model.}

\item{interact_var}{(\code{character})\cr name of the variable that should have interactions
with arm. If the interaction is not needed, the default option is \code{NULL}.}

\item{interact_y}{(\code{character})\cr a selected item from the interact_var column which will be used
to select the specific \code{ANCOVA} results when interact_var is discrete. If the interaction is not
needed, the default option is \code{FALSE}.}

\item{avisit}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr value of analysis
visit \code{AVISIT} of interest.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{pre_output}{optional, (\code{shiny.tag})\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{optional, (\code{shiny.tag})\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{optional, (\code{basic_table_args})\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a table to summarize analysis of variance, consistent with the TLG Catalog
template for \code{AOVT01} available \href{https://insightsengineering.github.io/tlg-catalog/stable/tables/efficacy/aovt01.html}{here} when multiple
endpoints are selected.
}
\details{
When a single endpoint is selected, both unadjusted and adjusted comparison are provided. This modules
expects that the analysis data has the following variables:
\itemize{
\item \code{AVISIT}: variable used to filter for analysis visits.
\item \code{PARAMCD}: variable used to filter for endpoints, after filtering for \code{paramcd} and \code{avisit}, one
observation per patient is expected for the analysis to be meaningful.
}
}
\examples{
ADSL <- tmc_ex_adsl
ADQS <- tmc_ex_adqs

arm_ref_comp <- list(
  ARM = list(
    ref = "B: Placebo",
    comp = c("A: Drug X", "C: Combination")
  ),
  ACTARMCD = list(
    ref = "ARM B",
    comp = c("ARM A", "ARM C")
  )
)

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADQS = ADQS,
    code = "
      ADSL <- tmc_ex_adsl
      ADQS <- tmc_ex_adqs
    "
  ),
  modules = modules(
    tm_t_ancova(
      label = "ANCOVA Table",
      dataname = "ADQS",
      avisit = choices_selected(
        choices = value_choices(ADQS, "AVISIT"),
        selected = "WEEK 1 DAY 8"
      ),
      arm_var = choices_selected(
        choices = variable_choices(ADSL, c("ARM", "ACTARMCD", "ARMCD")),
        selected = "ARMCD"
      ),
      arm_ref_comp = arm_ref_comp,
      aval_var = choices_selected(
        choices = variable_choices(ADQS, c("CHG", "AVAL")),
        selected = "CHG"
      ),
      cov_var = choices_selected(
        choices = variable_choices(ADQS, c("BASE", "STRATA1", "SEX")),
        selected = "STRATA1"
      ),
      paramcd = choices_selected(
        choices = value_choices(ADQS, "PARAMCD", "PARAM"),
        selected = "FKSI-FWB"
      ),
      interact_var = choices_selected(
        choices = variable_choices(ADQS, c("BASE", "STRATA1", "SEX")),
        selected = "STRATA1"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
