% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_therapy.R
\name{tm_g_pp_therapy}
\alias{tm_g_pp_therapy}
\title{teal Module: Patient Profile Therapy Table and Plot}
\usage{
tm_g_pp_therapy(
  label,
  dataname = "ADCM",
  parentname = "ADSL",
  patient_col = "USUBJID",
  atirel = NULL,
  cmdecod = NULL,
  cmindc = NULL,
  cmdose = NULL,
  cmtrt = NULL,
  cmdosu = NULL,
  cmroute = NULL,
  cmdosfrq = NULL,
  cmstdy = NULL,
  cmendy = NULL,
  font_size = c(12L, 12L, 25L),
  plot_height = c(700L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{atirel}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{ATIREL} variable from \code{dataname}.}

\item{cmdecod}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDECOD} variable from \code{dataname}.}

\item{cmindc}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMINDC} variable from \code{dataname}.}

\item{cmdose}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSE} variable from \code{dataname}.}

\item{cmtrt}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMTRT} variable from \code{dataname}.}

\item{cmdosu}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSU} variable from \code{dataname}.}

\item{cmroute}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMROUTE} variable from \code{dataname}.}

\item{cmdosfrq}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMDOSFRQ} variable from \code{dataname}.}

\item{cmstdy}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMSTDY} variable from \code{dataname}.}

\item{cmendy}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the \code{CMENDY} variable from \code{dataname}.}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{plot_height}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{optional, (\code{shiny.tag})\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{optional, (\code{shiny.tag})\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{optional, (\code{ggplot2_args})\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile therapy table and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type plot using ADaM datasets.
}
\examples{
library(nestcolor)
library(dplyr)

ADCM <- tmc_ex_adcm
ADSL <- tmc_ex_adsl \%>\% filter(USUBJID \%in\% ADCM$USUBJID)
ADCM$CMASTDTM <- ADCM$ASTDTM
ADCM$CMAENDTM <- ADCM$AENDTM
adcm_keys <- c("STUDYID", "USUBJID", "ASTDTM", "CMSEQ", "ATC1", "ATC2", "ATC3", "ATC4")

join_keys <- default_cdisc_join_keys[c("ADSL", "ADCM")]
join_keys["ADCM", "ADCM"] <- adcm_keys

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADCM = ADCM,
    code = "
      ADCM <- tmc_ex_adcm
      ADSL <- tmc_ex_adsl \%>\% filter(USUBJID \%in\% ADCM$USUBJID)
      ADCM$CMASTDTM <- ADCM$ASTDTM
      ADCM$CMAENDTM <- ADCM$AENDTM
    ",
    join_keys = join_keys
  ),
  modules = modules(
    tm_g_pp_therapy(
      label = "Therapy",
      dataname = "ADCM",
      parentname = "ADSL",
      patient_col = "USUBJID",
      plot_height = c(600L, 200L, 2000L),
      atirel = choices_selected(
        choices = variable_choices(ADCM, "ATIREL"),
        selected = c("ATIREL")
      ),
      cmdecod = choices_selected(
        choices = variable_choices(ADCM, "CMDECOD"),
        selected = "CMDECOD"
      ),
      cmindc = choices_selected(
        choices = variable_choices(ADCM, "CMINDC"),
        selected = "CMINDC"
      ),
      cmdose = choices_selected(
        choices = variable_choices(ADCM, "CMDOSE"),
        selected = "CMDOSE"
      ),
      cmtrt = choices_selected(
        choices = variable_choices(ADCM, "CMTRT"),
        selected = "CMTRT"
      ),
      cmdosu = choices_selected(
        choices = variable_choices(ADCM, "CMDOSU"),
        selected = c("CMDOSU")
      ),
      cmroute = choices_selected(
        choices = variable_choices(ADCM, "CMROUTE"),
        selected = "CMROUTE"
      ),
      cmdosfrq = choices_selected(
        choices = variable_choices(ADCM, "CMDOSFRQ"),
        selected = "CMDOSFRQ"
      ),
      cmstdy = choices_selected(
        choices = variable_choices(ADCM, "ASTDY"),
        selected = "ASTDY"
      ),
      cmendy = choices_selected(
        choices = variable_choices(ADCM, "AENDY"),
        selected = "AENDY"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
