% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{column_annotation_label}
\alias{column_annotation_label}
\title{Get full label, useful for annotating plots}
\usage{
column_annotation_label(dataset, column, omit_raw_name = FALSE)
}
\arguments{
\item{dataset}{(\code{data.frame})\cr dataset}

\item{column}{(\code{character})\cr column to get label from}

\item{omit_raw_name}{(\code{logical})\cr omits the raw name in square brackets if label is found}
}
\value{
"Label \verb{[Column name]}" if label exists, otherwise "Column name"
}
\description{
Get full label, useful for annotating plots
}
\examples{
data <- mtcars
column_annotation_label(data, "cyl")
attr(data[["cyl"]], "label") <- "Cylinder"
column_annotation_label(data, "cyl")
column_annotation_label(data, "cyl", omit_raw_name = TRUE)
column_annotation_label(tmc_ex_adsl, "ACTARM")
}
