% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_ipp.R
\name{template_g_ipp}
\alias{template_g_ipp}
\title{Template: Individual Patient Plots}
\usage{
template_g_ipp(
  dataname = "ANL",
  paramcd,
  arm_var,
  arm_levels,
  avalu_first,
  paramcd_first,
  aval_var = "AVAL",
  avalu_var = "AVALU",
  id_var = "USUBJID",
  visit_var = "AVISIT",
  baseline_var = "BASE",
  add_baseline_hline = FALSE,
  separate_by_obs = FALSE,
  ggplot2_args = teal.widgets::ggplot2_args(),
  suppress_legend = FALSE,
  add_avalu = TRUE
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{paramcd}{(\code{character})\cr name of the parameter code variable.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{arm_levels}{(\code{character})\cr vector of all levels of \code{arm_var}.}

\item{avalu_first}{(\code{character})\cr \code{avalu_var} text to append to the plot title and y-axis label if \code{add_avalu} is
\code{TRUE}.}

\item{paramcd_first}{(\code{character})\cr \code{paramcd} text to append to the plot title and y-axis label.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{avalu_var}{(\code{character})\cr name of the analysis value unit variable.}

\item{id_var}{(\code{character})\cr the variable name for subject id.}

\item{visit_var}{(\code{character})\cr name of the variable for visit timepoints.}

\item{baseline_var}{(\code{character})\cr name of the variable for baseline values of the analysis variable.}

\item{add_baseline_hline}{(\code{logical})\cr whether a horizontal line should be added to the plot at baseline y-value.}

\item{separate_by_obs}{(\code{logical})\cr whether to create multi-panel plots.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. For this module, this argument will only accept \code{ggplot2_args} object with \code{labs} list of
the following child elements: \code{title}, \code{subtitle}, \code{x}, \code{y}. No other elements are taken into account. The
argument is merged with option \code{teal.ggplot2_args} and with default module arguments (hard coded in the module
body).

For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{suppress_legend}{(\code{logical})\cr whether to suppress the plot legend.}

\item{add_avalu}{(\code{logical})\cr whether \code{avalu_first} text should be appended to the plot title and y-axis label.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plots of individual patients.
}
\seealso{
\code{\link[=tm_g_ipp]{tm_g_ipp()}}
}
\keyword{internal}
