% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data-class.R
\docType{class}
\name{teal_data-class}
\alias{teal_data-class}
\title{Reproducible data}
\description{
Reproducible data container class. Inherits code tracking behavior from \code{\link[teal.code:qenv-class]{teal.code::qenv}}.
}
\details{
This class provides an isolated environment in which to store and process data with all code being recorded.
The environment, code, data set names, and data joining keys are stored in their respective slots.
These slots should never be accessed directly, use the provided get/set functions.

As code is evaluated in \code{teal_data}, messages and warnings are stored in their respective slots.
If errors are raised, a \code{qenv.error} object is returned.
}
\section{Slots}{

\describe{
\item{\code{env}}{(\code{environment}) environment containing data sets and possibly auxiliary variables.
Access variables with \code{\link[=get_var]{get_var()}} or [\code{[[}].
No setter provided. Evaluate code to add variables into \verb{@env}.}

\item{\code{code}}{(\code{character}) vector representing code necessary to reproduce the contents of \verb{@env}.
Access with \code{\link[=get_code]{get_code()}}.
No setter provided. Evaluate code to append code to the slot.}

\item{\code{id}}{(\code{integer}) random identifier assigned to each element of \verb{@code}. Used internally.}

\item{\code{warnings}}{(\code{character}) vector of warnings raised when evaluating code.
Access with \code{\link[=get_warnings]{get_warnings()}}.}

\item{\code{messages}}{(\code{character}) vector of messages raised when evaluating code.}

\item{\code{join_keys}}{(\code{join_keys}) object specifying joining keys for data sets in \verb{@env}.
Access or modify with \code{\link[=join_keys]{join_keys()}}.}

\item{\code{datanames}}{(\code{character}) vector of names of data sets in \verb{@env}.
Used internally to distinguish them from auxiliary variables.
Access or modify with \code{\link[=datanames]{datanames()}}.}

\item{\code{verified}}{(\code{logical(1)}) flag signifying that code in \verb{@code} has been proven to yield contents of \verb{@env}.
Used internally. See \code{\link[=verify]{verify()}} for more details.}
}}

\keyword{internal}
