% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify}
\alias{verify}
\alias{verify,teal_data-method}
\alias{verify,qenv.error-method}
\title{Verify code reproducibility}
\usage{
verify(x)
}
\arguments{
\item{x}{\code{teal_data} object}
}
\value{
Input \code{teal_data} object or error.
}
\description{
Checks whether code in \code{teal_data} object reproduces the stored objects.
}
\details{
If objects created by code in the \verb{@code} slot of \code{x} are \code{all_equal} to the contents of the \verb{@env} slot,
the function updates the \verb{@verified} slot to \code{TRUE} in the returned \code{teal_data} object.
Once verified, the slot will always be set to \code{TRUE}.
If the \verb{@code} fails to recreate objects in \code{teal_data@env}, an error is raised.
}
\examples{
tdata1 <- teal_data()
tdata1 <- within(tdata1, {
  a <- 1
  b <- a^5
  c <- list(x = 2)
})
verify(tdata1)

tdata2 <- teal_data(x1 = iris, code = "x1 <- iris")
verify(tdata2)
verify(tdata2)@verified
tdata2@verified

tdata3 <- teal_data()
tdata3 <- within(tdata3, {
  stop("error")
})
try(verify(tdata3)) # fails


a <- 1
b <- a + 2
c <- list(x = 2)
d <- 5
tdata4 <- teal_data(
  a = a, b = b, c = c, d = d,
  code = "a <- 1
          b <- a
          c <- list(x = 2)
          e <- 1"
)
tdata4
try(verify(tdata4)) # fails

}
