\name{RT}
\alias{RT}
\title{
Adaptive choice of the optimal sample fraction in tail index estimation
}
\description{
An implementation of the minimization criterion proposed in Reiss & Thomas (2007).
}
\usage{
RT(data, beta = 0, kmin = 2)
}
\arguments{
  \item{data}{
vector of sample data
}
\item{beta}{
a factor for weighting the expression below. Default is set to \code{beta=0}
}
  \item{kmin}{
gives a minimum value for \code{k}. Default ist set to \code{kmin=2}.
}
}
\details{
The procedure proposed in Reiss & Thomas (2007) chooses the lowest upper order statistic \code{k} to minimize the expression
\code{1/k sum_i=1^k i^beta |gamma_i-median(gamma_1,...,gamma_k)|}
or an alternative of that by replacing the absolute deviation with a squared deviation and the median just with \code{gamma_k}, where \code{gamma} denotes the Hill estimator
}
\value{
\item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail for both metrics, i.e. the absolute and squared deviation.}
  \item{threshold}{the corresponding thresholds.}
  \item{tail.index}{the corresponding tail indices}
}
\references{
Reiss, R.-D. and Thomas, M. (2007)
Statistical Analysis of Extreme Values: With Applications to Insurance, Finance, Hydrology and Other Fields.
\emph{Birkhauser, Boston}.
}
\examples{
data(danish)
RT(danish)
}
