% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data.wdi.search}
\alias{data.wdi.search}
\title{Finds a Series in WDI Dataset}
\usage{
data.wdi.search(
  series,
  keywords,
  searchName = TRUE,
  searchDesc = FALSE,
  topicKeywords = NULL,
  findOne = FALSE
)
}
\arguments{
\item{series}{This must be the \code{series} field in the output of the \code{\link{data.wdi.agg}} function.}

\item{keywords}{(character array) Keywords to be used for searching.}

\item{searchName}{If \code{FALSE}, it does not search in the names field.}

\item{searchDesc}{If \code{FALSE}, it does not search in the description}

\item{topicKeywords}{If given, topic of a matched case must contain these keywords, too.}

\item{findOne}{Raises error if \code{TRUE} and more than 1 series is found. default is \code{FALSE}.}
}
\value{
If \code{findOne} is \code{TRUE}, it is a series information. Otherwise, it is a list with series information.
}
\description{
Use it to search for a series in the WDI dataset by its name, description, and some other attributes.
}
\examples{
#data <- data.wdi.agg() # this is time-consuming and requires WDI dataset files
#res <- data.wdi.search(data$series, c("GDP per capita"),
#                        TRUE, topicKeywords = "national account")

}
