% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_effect}
\alias{tci_effect}
\title{TCI algorithm for effect-site targeting}
\usage{
tci_effect(
  Cet,
  pkmod,
  dtm = 1/6,
  ecmpt = NULL,
  tmax_search = 10,
  maxrt = 1200,
  grid_len = 1200,
  ...
)
}
\arguments{
\item{Cet}{Numeric vector of target effect-site concentrations.}

\item{pkmod}{PK model}

\item{dtm}{Frequency of TCI updates. Default is 1/6 minutes = 10 seconds.}

\item{ecmpt}{Effect site compartment number}

\item{tmax_search}{Outer bound on times searched to find a maximum concentration
following an infusion of duration dtm. Defaults to 20 minutes. May need to be increased
if a drug has a slow elimination rate.}

\item{maxrt}{Maximum infusion rate of TCI pump. Defaults to 1200.}

\item{grid_len}{Number of time points used to identify time of maximum concentration.
Can be increased for more precision.}

\item{...}{Arguments used by pkmod.}
}
\value{
Numeric value
}
\description{
Function for calculating a TCI infusion schedule corresponding to a set of target concentrations.
This function makes use of formulas described by Shafer and Gregg (1992) in "Algorithms to rapidly achieve
and maintain stable drug concentrations at the site of drug effect with a computer-controlled infusion pump"
}
\examples{
tci_effect(Cet = 2, pkmod = pkmod2cpt, dtm = 1, pars = c(CL = 15, V1 = 10, Q2 = 10, V2 = 20))
}
