% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crosses.R
\name{ozScore}
\alias{ozScore}
\title{Overlap Z-score.}
\usage{
ozScore(.mat, .symm = T, .as.matrix = F, .val.col = c("norm", "abs",
  "oz"))
}
\arguments{
\item{.mat}{Matrix with overlap values.}

\item{.symm}{If T then remove lower triangle matrix from counting. Doesn't work if the matrix
has different number of rows and columns.}

\item{.as.matrix}{If T then return}

\item{.val.col}{If .as.matrix is T then this is a name of the column to build matrix upon:
either "oz" for the OZ-score column, "abs" for the absolute OZ-score column, or "norm" for the
normalised absolute OZ-score column.}
}
\description{
Compute OZ-scores ("overlap Z scores") for values in the given matrix of overlaps, i.e.,.
for each value compute the number of standart deviations from the mean of the matrix.
}
\examples{
\dontrun{
data(twb)
mat <- repOverlap(twb)
ozScore(mat)
# Take 3x3 matrix
ozScore(mat[1:3, 1:3])
# Return as matrix with OZ scores
ozmat <- ozScore(mat, T, T, 'oz')
# Return as matrix with normalised absolute OZ scores
oznorm <- ozScore(mat, T, T, 'norm')
# Plot it as boxplots
sb <- matrixSubgroups(oznorm, list(tw1 = c('Subj.A', 'Subj.B'), tw2 = c('Subj.C', 'Subj.D')));
vis.group.boxplot(sb)
}
}
\seealso{
\link{repOverlap}, \link{intersectClonesets}, \link{permutDistTest}
}

