% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DwC2taxo.R
\name{DwC2taxo}
\alias{DwC2taxo}
\title{Darwin Core to Taxolist format}
\usage{
DwC2taxo(namelist, statuslist = NA, source = NA)
}
\arguments{
\item{namelist}{names list in Darwin Core format}

\item{statuslist}{vector listing taxonomicStatus to be considered in
the namelist. If Default value is NA, automatically uses list of
\itemize{\item{Accepted}\item{Synonym}\item{Valid}
\item{heterotypicSynonym}#' \item{homotypicSynonym}}}

\item{source}{source of the namelist. Default NA}
}
\value{
names list is taxolist format
}
\description{
Converts a Darwin Core name list to taxolist format
}
\details{
The name lists downloaded for ITIS website in Darwin Core format has
all the required fields. Just needs to be converted and quality checked in terms
 of missing linkages
}
\examples{
\dontrun{
if(interactive()){
 taxolist <- DwC2taxo(namelist)
 }
}
}
\seealso{
Other list functions: 
\code{\link{match_lists}()},
\code{\link{synonymize_subspecies}()}
}
\concept{list functions}
