% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_lists.R
\name{merge_lists}
\alias{merge_lists}
\title{merge two lists of names}
\usage{
merge_lists(master = NULL, checklist = NULL, output = "all", verbose = TRUE)
}
\arguments{
\item{master}{master list of names}

\item{checklist}{list to be merged}

\item{output}{data returned by the function, one of the five options all, 
onlyadd, add, merged, new or multi. Default all}

\item{verbose}{verbose output on the console}
}
\value{
Data frame with addition column merge_tag. The merge_tag contains 
four possible values. \itemize{\item{orig - }{names in the master}\item{add -
 }{ checklist names that matched using synonym linkages including direct 
 matches} \item{new - }{checklist names that did NOT match with master.
 Potentially new taxa} \item{multi -}{taxon from checklist for which two
 synonyms matched with two different accepted names in master}}
}
\description{
Useful in generating a master list of names from multiple
sources
}
\details{
Matches names is checklist with names on master and returns 
following data:
\itemize{\item{all }{= orig + add + new + multi: all the data} \item{onlyadd
 }{= add : returns records from checklist that match with master}
\item{add }{= orig + add : returns all records from master + matched records
 from checklist} \item{merged }{= orig + add + new : returns all records from
 master + matched records from checklist + new taxon from checklist}
 \item{new }{= returns only new taxon entities that did not match with 
 master} \item{multi }{= taxon from checklist for which two synonyms matched
  with two different accepted names in master}}
}
\examples{
\donttest{
master <- data.frame("id" = c(1,2,3),
                     "canonical" = c("Hypochlorosis ancharia",
                                     "Hypochlorosis tenebrosa",
                                     "Hypochlorosis ancharia tenebrosa"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae"),
                     "accid" = c(0,1,0),
                     "source" = c("itis","itis","itis"),
                     stringsAsFactors = FALSE)

checklist <- data.frame("id" = c(1,2,3,4,5),
                        "canonical" = c("Hypochlorosis ancharia",
                                        "Pseudonotis humboldti",
                                        "Myrina ancharia",
                                        "Hypochlorosis ancharia obiana",
                                        "Hypochlorosis lorquinii"),
                        "family" = c("Lycaenidae", "Lycaenidae", 
                                     "Lycaenidae", "Lycaenidae",
                                      "Lycaenidae"),
                        "accid" = c(0,1,1,0,0),
                        "source" = c("itis","wiki","wiki","itis",
                                     "itis"),
                        stringsAsFactors = FALSE)
merged_all <- merge_lists(master,checklist,output="all")
new_taxa <- merge_lists(master,checklist,output="new")
merged_with_new <- merge_lists(master,checklist,output="merged")
merged_add <- merge_lists(master,checklist,output="add")
multi_linked <- merge_lists(master,checklist,output="multi")
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
