% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax2traits.R
\name{tax2traits}
\alias{tax2traits}
\alias{tax2traits,taxlist-method}
\title{Set taxonomic information as taxon traits}
\usage{
tax2traits(object, ...)

\S4method{tax2traits}{taxlist}(object, get_names = FALSE, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{taxlist}.}

\item{...}{Further arguments to be passed among methods.}

\item{get_names}{Logical value indicating whether taxon names should be
retrieved instead of taxon IDs.}
}
\value{
An object of class \linkS4class{taxlist} with taxonomy added
as traits.
}
\description{
Taxonomic classification can be included in \linkS4class{taxlist}
objects within the information provided at slot \code{taxonRelations}.
Nevertheless, for statistical analyses it may be more convenient to insert
such information in the slot \code{taxonTraits}.
}
\details{
This function can only be applied to objects containing parent-child
relationships and information on taxonomic levels.
}
\examples{
## Family Acanthaceae with children
Acanthaceae <- subset(
  x = Easplist, subset = TaxonName == "Acanthaceae",
  slot = "names", keep_children = TRUE
)
summary(Acanthaceae)

## Insert taxonomy to taxon traits
Acanthaceae <- tax2traits(Acanthaceae, get_names = TRUE)
head(taxon_traits(Acanthaceae))
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}.
}
