% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.R
\name{Extract}
\alias{Extract}
\alias{[}
\alias{[,taxlist-method}
\alias{$,taxlist-method}
\alias{$}
\title{Extract or Replace Parts of taxlist Objects}
\usage{
\S4method{[}{taxlist}(x, i, j, drop = FALSE)

\S4method{$}{taxlist}(x, name)
}
\arguments{
\item{x}{Object of class \linkS4class{taxlist}.}

\item{i}{Integer or logical vector used as index for access to taxon
concepts, referring to the rows in slot 'taxonRelations'. These indices can
be used to produce a object with a subset of taxon concepts. It is not
recommended to use character values for this index.}

\item{j}{Integer, logical or character vector used as index for access to
variables in slot 'taxonTraits'. These indices can be used to reduce the
number of variables in the mentioned slot.}

\item{drop}{A logical value passed to \code{\link[base]{Extract}}.}

\item{name}{A symbol or character value for the method \code{$}, corresponding to
a variable either at slot 'taxonTraits' or slot 'taxonRelations'.}
}
\value{
The method \code{$} retrieves a vector, while \code{[} retrieves a subset
of the input \linkS4class{taxlist} object.
}
\description{
Quick access to slots \code{taxonTraits} and \code{taxonRelations} within
\linkS4class{taxlist} objects.
}
\examples{
## Statistics on life forms
summary(as.factor(Easplist$lf_behn_2018))

## First ten concepts in this list
summary(Easplist[1:10, ], "all")

}
\seealso{
\linkS4class{taxlist} \code{\link[taxlist]{subset}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}.
}
