% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_download.R
\name{db_download}
\alias{db_download}
\alias{db_download_itis}
\alias{db_download_tpl}
\alias{db_download_col}
\alias{db_download_gbif}
\title{Download taxonomic databases}
\usage{
db_download_itis(verbose = TRUE)

db_download_tpl(verbose = TRUE)

db_download_col(verbose = TRUE)

db_download_gbif(verbose = TRUE)
}
\arguments{
\item{verbose}{(logical) Print messages. Default: \code{TRUE}}
}
\value{
Path to the downloaded SQL database
}
\description{
Download taxonomic databases
}
\details{
Downloads sql database, cleans up unneeded files, returns path
to sql file
}
\section{Supported}{

\itemize{
\item ITIS - PostgreSQL
\item The PlantList - PostgreSQL
\item Catalogue of Life - MySQL
\item GBIF - SQLite
}
}

\section{Beware}{

COL database loading takes a long time, e.g., 30 minutes. you may
want to run it in a separate R session, or just look at the db_load_col fxn
and run the commands in your shell.
}

\examples{
\dontrun{
# ITIS
# x <- db_download_itis()
# db_load_itis(x)
# src_itis()

# Plantlist
# x <- db_download_tpl()
# db_load_tpl(x, "sacmac")
# src_tpl()

# COL
# x <- db_download_col()
# db_load_col(x)
# src_col()

# GBIF
# x <- db_download_gbif()
# db_load_gbif()
# src_gbif(x)
}
}
\seealso{
\link{tdb_cache}
}
