% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_downstream.R
\name{gbif_downstream}
\alias{gbif_downstream}
\title{Retrieve all taxa names downstream in hierarchy for GBIF}
\usage{
gbif_downstream(
  key,
  downto,
  intermediate = FALSE,
  limit = 100,
  start = NULL,
  ...
)
}
\arguments{
\item{key}{A taxonomic serial number.}

\item{downto}{The taxonomic level you want to go down to. See examples below.
The taxonomic level IS case sensitive, and you do have to spell it
correctly. See \code{data(rank_ref)} for spelling.}

\item{intermediate}{(logical) If TRUE, return a list of length two with
target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: FALSE}

\item{limit}{Number of records to return}

\item{start}{Record number to start at}

\item{...}{Further args passed on to \code{\link[=gbif_name_usage]{gbif_name_usage()}}}
}
\value{
data.frame of taxonomic information downstream to family from e.g.,
Order, Class, etc., or if \code{intermediated=TRUE}, list of length two,
with target taxon rank names, and intermediate names.
}
\description{
Retrieve all taxa names downstream in hierarchy for GBIF
}
\details{
Sometimes records don't have a \code{canonicalName} entry which is
what we look for. In that case we grab the \code{scientificName} entry.
You can see the type of name colleceted in the column \code{name_type}
}
\examples{
\dontrun{
## the plant class Bangiophyceae
gbif_downstream(key = 198, downto="genus")
gbif_downstream(key = 198, downto="genus", intermediate=TRUE)

# families downstream from the family Strepsiptera (twisted wing parasites)
gbif_downstream(key = 1227, "family")
## here, intermediate leads to the same result as the target
gbif_downstream(key = 1227, "family", intermediate=TRUE)

# Lepidoptera
gbif_downstream(key = 797, "family")

# get species downstream from the genus Ursus
gbif_downstream(key = 2433406, "species")

# get tribes down from the family Apidae
gbif_downstream(key = 7799978, downto="species")
gbif_downstream(key = 7799978, downto="species", intermediate=TRUE)

# names that don't have canonicalname entries for some results
# Myosotis: key 2925668
key <- 2925668
res <- gbif_downstream(key, downto = "species")
res2 <- downstream(key, db = "gbif", downto = "species")
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
