% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_state.R
\docType{data}
\name{taxon_state}
\alias{taxon_state}
\title{Keep track of queries in \code{get_*} functions}
\arguments{
\item{class}{(character) a class name (e.g., "gbif")}

\item{names}{(character) one or more taxon names}
}
\description{
This object lives inside each \code{get_*} function call, maintaining
results as they are accumulated.
}
\details{
\strong{Methods}
\describe{
\item{\code{add(query, result)}}{
add a record with it's result; duplicates allowed
- query (character), a taxon name
- result (list) a named list
}
\item{\code{get(query)}}{
get all records matching 'query'
- query (character), a taxon name
}
\item{\code{remove(query)}}{
remove's all records matching 'query'
- query (character), a taxon name
}
\item{\code{purge()}}{
removes all records
}
\item{\code{taxa_remaining()}}{
get remaining taxa
}
\item{\code{taxa_completed()}}{
get remaining taxa
}
\item{\code{count} (active binding)}{
count number of records
}
\item{\code{exit} (active binding)}{
record date/time function exited
}
}
}
\examples{
\dontrun{
ts <- taxon_state$new()
taxon_last()
ts
res <- list(
  id = 123456,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "tsn"
)
ts$add(query = "Quercus robur", result = res)
ts
ts$get(query = "Quercus robur")
ts$count
ts$remove(query = "Quercus robur")
ts
ts$count

res2 <- list(
  id = 3430834535,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "gbifid"
)
ts$add(query = "Poa annua", result = res2)
res3 <- list(
  id = 1223424,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "uid"
)
ts$add(query = "Puma concolor", result = res3)
ts
ts$count
ts$get("Puma concolor")
ts$get()

# cleanup
ts$purge()
ts$count
}
}
\keyword{internal}
