% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncbi_get_taxon_summary.R
\name{ncbi_get_taxon_summary}
\alias{ncbi_get_taxon_summary}
\title{NCBI taxon information from uids}
\usage{
ncbi_get_taxon_summary(id, key = NULL, ...)
}
\arguments{
\item{id}{(character) NCBI taxonomy uids to retrieve information for.
See Details.}

\item{key}{(character) NCBI Entrez API key. optional. See Details.}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{uid} The uid queried for
\item \code{name} The name of the taxon; a binomial name if the taxon is of rank species
\item \code{rank} The taxonomic rank (e.g. 'Genus')
}
}
\description{
Downloads summary taxon information from the NCBI taxonomy
databases for a set of taxonomy UIDs using eutils esummary.
}
\details{
If your input vector or list of NCBI IDs is longer than about
2500 characters (use \code{nchar(paste(ids, collapse = "+"))}), split
the list up into chunks since at about that number of characters you
will run into the HTTP 414 error "Request-URI Too Long".
}
\section{Authentication}{

See \link{taxize-authentication} for help on authentication.
We strongly recommend getting an API key
}

\examples{
\dontrun{
ncbi_get_taxon_summary(c(1430660, 4751))

# use curl options
ncbi_get_taxon_summary(c(1430660, 4751), verbose = TRUE)
}
}
\author{
Zachary Foster \email{zacharyfoster1989@Sgmail.com}
}
