% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnrs.R
\name{tnrs}
\alias{tnrs}
\title{Phylotastic Taxonomic Name Resolution Service.}
\usage{
tnrs(query = NA, source = NULL, code = NULL, getpost = "POST",
  sleep = 0, splitby = 30, verbose = TRUE, ...)
}
\arguments{
\item{query}{Vector of quoted taxonomic names to search (character).}

\item{source}{Specify the source you want to match names against. Defaults
  to just retrieve data from all sources. Options: NCBI, iPlant_TNRS,
or MSW3. Only available when using getpost="POST".}

\item{code}{Nomenclatural code. One of: ICZN (zoological), ICN (algae, fungi,
and plants), ICNB (bacteria), ICBN (botanical), ICNCP (cultivated plants),
ICTV (viruses). Only available when using getpost="POST".}

\item{getpost}{Use GET or POST method to send the query. If you have more
than say 50 species or so in your query, you should probably use POST.
IMPORTANT!!!!! ->
    POST is the only option for this parameter if you want to
    use source or code parameters.}

\item{sleep}{Number of seconds by which to pause between calls. Defaults to 0
seconds. Use when doing many calls in a for loop ar lapply type call.}

\item{splitby}{Number by which to split species list for querying the TNRS.}

\item{verbose}{Verbosity or not (default \code{TRUE})}

\item{...}{Curl options to pass in \code{\link[httr]{GET}} or
\code{\link[httr]{POST}}}
}
\value{
data.frame of results from TNRS plus the name submitted, with
rows in order of user supplied names, though those with no matches are
dropped
}
\description{
Match taxonomic names using the Taxonomic Name Resolution
Service (TNRS). Returns score of the matched name, and whether it was
accepted or not.
}
\details{
If there is no match in the Taxosaurus database, nothing is
returned, so you will not get anything back for non-matches.

TNRS doesn't provide any advice about the occurrence of homonyms when
queries have no indication of a taxonomic name's authority. So if there
is any chance of a homonym, you probably want to send the authority as
well, or use \code{\link{gnr_resolve}}. For example,
\code{tnrs(query="Jussiaea linearis", source="iPlant_TNRS")} gives result of
\emph{Jussiaea linearis (Willd.) Oliv. ex Kuntze}, but there is a
homonym. If you do
\code{tnrs(query="Jussiaea linearis Hochst.", source="iPlant_TNRS")} you
get a direct match for that name. So, beware that there's no indication
of homonyms.
}
\examples{
\dontrun{
mynames <- c("Helianthus annuus", "Poa annua", "Mimulus bicolor")
tnrs(query = mynames, source = "iPlant_TNRS")

# Specifying the nomenclatural code to match against
mynames <- c("Helianthus annuus", "Poa annua")
tnrs(query = mynames, code = "ICBN")

# You can specify multiple sources, by comma-separating them
mynames <- c("Panthera tigris", "Eutamias minimus", "Magnifera indica",
"Humbert humbert")
tnrs(query = mynames, source = "NCBI,MSW3")

mynames <- c("Panthera tigris", "Eutamias minimus", "Magnifera indica",
   "Humbert humbert", "Helianthus annuus", "Pinus contorta", "Poa annua",
   "Abies magnifica", "Rosa california", "Festuca arundinace",
   "Mimulus bicolor", "Sorbus occidentalis","Madia sativa", "Thymopsis thymodes",
   "Bartlettia scaposa")
tnrs(mynames, source = "NCBI")

# Pass on curl options
library("httr")
mynames <- c("Helianthus annuus", "Poa annua", "Mimulus bicolor")
tnrs(query = mynames, source = "iPlant_TNRS", config = verbose())
}
}
\references{
\url{http://taxosaurus.org/}
}
\seealso{
\code{\link{gnr_resolve}}
}
