% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_rank.R
\name{tax_rank}
\alias{tax_rank}
\title{Get rank for a given taxonomic name.}
\usage{
tax_rank(x, db = NULL, ...)
}
\arguments{
\item{x}{(character) Vector of one or more taxon names (character) or
IDs (character or numeric) to query. Or objects returned from
\code{get_*()} functions like \code{\link{get_tsn}}}

\item{db}{(character) database to query. either \code{ncbi}, \code{itis},
\code{eol}, \code{col}, \code{tropicos}, \code{gbif}, \code{nbn},
\code{worms}, \code{natserv}, \code{bold}. Note that each taxonomic data
source has their own identifiers, so that if you provide the wrong
\code{db} value for the identifier you may get a result, but it will
likely be wrong (not what you were expecting).}

\item{...}{Additional arguments to \code{\link{classification}}}
}
\value{
A named list of character vectors with ranks (all lower-cased)
}
\description{
Get rank for a given taxonomic name.
}
\note{
While \code{\link[taxize]{tax_name}} returns the name of a specified
rank, \code{\link[taxize]{tax_rank}} returns the actual rank of the taxon.
}
\examples{
\dontrun{
tax_rank(x = "Helianthus annuus", db = "itis")
tax_rank(get_tsn("Helianthus annuus"))
tax_rank(c("Helianthus", "Pinus", "Poa"), db = "itis")

tax_rank(get_boldid("Helianthus annuus"))
tax_rank("421377", db = "bold")
tax_rank(421377, db = "bold")

tax_rank(c("Plantae", "Helianthus annuus",
  "Puma", "Homo sapiens"), db = 'itis')
tax_rank(c("Helianthus annuus", "Quercus", "Fabaceae"), db = 'tropicos')

tax_rank(names_list("species"), db = 'gbif')
tax_rank(names_list("family"), db = 'gbif')

tax_rank(c("Platanista gangetica", "Lichenopora neapolitana"),
  db = "worms")
}
}
\seealso{
\code{\link[taxize]{classification}}, \code{\link[taxize]{tax_name}}
}
