% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxonomy.R
\name{tax_name.taxa_classification}
\alias{tax_name.taxa_classification}
\alias{tax_name<-.taxa_classification}
\alias{tax_name}
\alias{tax_name<-}
\alias{tax_name.taxa_taxon}
\alias{tax_name<-.taxa_taxon}
\alias{tax_name.taxa_taxonomy}
\alias{tax_name<-.taxa_taxonomy}
\title{Set and get taxon names}
\usage{
\method{tax_name}{taxa_classification}(x)

\method{tax_name}{taxa_classification}(x) <- value

tax_name(x)

tax_name(x) <- value

\method{tax_name}{taxa_taxon}(x)

\method{tax_name}{taxa_taxon}(x) <- value

\method{tax_name}{taxa_taxonomy}(x)

\method{tax_name}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon names.}

\item{value}{The taxon names to set. Inputs will be coerced into a \link{character} vector.}
}
\description{
Set and get the taxon names in objects that have them, such as \link{taxon} objects.
Note that this is not the same as adding vector names with \link{names}.
}
\examples{
x <- taxon(name = c('Homo sapiens', 'Bacillus', 'Ascomycota', 'Ericaceae'),
           rank = c('species', 'genus', 'phylum', 'family'),
           id = taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi'),
           auth = c('Linnaeus, 1758', 'Cohn 1872', NA, 'Juss., 1789'))

tax_name(x)
tax_name(x) <- tolower(tax_name(x))
tax_name(x)[1] <- 'Billy'

}
