% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{taxon_indexes}
\alias{taxon_indexes}
\title{Get taxon indexes}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}
}
\description{
Return the taxon indexes in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.
They are the indexes of the edge list rows.
\preformatted{
obj$taxon_indexes()
taxon_indexes(obj)}
}
\examples{
# Return the indexes for each taxon
taxon_indexes(ex_taxmap)

# Use in another function (stupid example; 1:5 would work too)
filter_taxa(ex_taxmap, taxon_indexes < 5)

}
\seealso{
Other taxonomy data functions: \code{\link{classifications}},
  \code{\link{id_classifications}},
  \code{\link{is_branch}}, \code{\link{is_internode}},
  \code{\link{is_leaf}}, \code{\link{is_root}},
  \code{\link{is_stem}}, \code{\link{map_data_}},
  \code{\link{map_data}}, \code{\link{n_leaves_1}},
  \code{\link{n_leaves}}, \code{\link{n_subtaxa_1}},
  \code{\link{n_subtaxa}}, \code{\link{n_supertaxa_1}},
  \code{\link{n_supertaxa}}, \code{\link{taxon_ids}},
  \code{\link{taxon_names}}, \code{\link{taxon_ranks}}
}
\concept{taxonomy data functions}
