% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{replace_taxon_ids}
\alias{replace_taxon_ids}
\title{Replace taxon ids}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}

\item{new_ids}{A vector of new ids, one per taxon. They must be unique and in
the same order as the corresponding ids in \code{obj$taxon_ids()}.}
}
\value{
A \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object with new taxon ids
}
\description{
Replace taxon ids in a \code{\link[=taxmap]{taxmap()}} or \code{\link[=taxonomy]{taxonomy()}} object.
\preformatted{
obj$replace_taxon_ids(new_ids)
replace_taxon_ids(obj, new_ids)}
}
\examples{
# Replace taxon IDs with numbers
replace_taxon_ids(ex_taxmap, seq_len(length(ex_taxmap$taxa)))

# Make taxon IDs capital letters
replace_taxon_ids(ex_taxmap, toupper(taxon_ids(ex_taxmap)))

}
