% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--docs.R
\name{sample_frac_obs}
\alias{sample_frac_obs}
\title{Sample a proportion of observations from \code{\link[=taxmap]{taxmap()}}}
\arguments{
\item{obj}{(\code{\link[=taxmap]{taxmap()}}) The object to sample from.}

\item{target}{The name of the table in \code{obj$data} to filter}

\item{size}{(\code{numeric} of length 1) The proportion of observations to
sample.}

\item{replace}{(\code{logical} of length 1) If \code{TRUE}, sample with
replacement.}

\item{taxon_weight}{(\code{numeric}) Non-negative sampling weights of each
taxon. If \code{use_supertaxa} is \code{TRUE}, the weights for each taxon
in an observation's classification are supplied to \code{collapse_func} to
get the observation weight. If \code{obs_weight} is also specified, the two
weights are multiplied (after \code{taxon_weight} for each observation is
calculated).}

\item{obs_weight}{(\code{numeric}) Sampling weights of each observation.  If
\code{taxon_weight} is also specified, the two weights are multiplied
(after \code{taxon_weight} for each observation is calculated).}

\item{use_supertaxa}{(\code{logical} or \code{numeric} of length 1) Affects how the
\code{taxon_weight} is used. If \code{TRUE}, the weights for each taxon in
an observation's classification are multiplied to get the observation
weight. If \code{FALSE} just the taxonomic level the observation is assign to it
considered. Positive numbers indicate the number of ranks above the
each taxon to use. \code{0} is equivalent to \code{FALSE}. Negative numbers
are equivalent to \code{TRUE}.}

\item{collapse_func}{(\code{function} of length 1) If \code{taxon_weight}
option is used and \code{supertaxa} is \code{TRUE}, the weights for each
taxon in an observation's classification are supplied to
\code{collapse_func} to get the observation weight. This function should
take  numeric vector and return a single number.}

\item{...}{Additional options are passed to \code{\link[=filter_obs]{filter_obs()}}.}
}
\value{
An object of type \code{\link[=taxmap]{taxmap()}}
}
\description{
Randomly sample some proportion of observations from a \code{\link[=taxmap]{taxmap()}}
object. Weights can be specified for observations or their taxa. See
\code{\link[dplyr:sample_frac]{dplyr::sample_frac()}} for the inspiration for this function.
\preformatted{
obj$sample_frac_obs(target, size, replace = FALSE,
  taxon_weight = NULL, obs_weight = NULL,
  use_supertaxa = TRUE, collapse_func = mean, ...)
sample_frac_obs(obj, target, size, replace = FALSE,
  taxon_weight = NULL, obs_weight = NULL,
  use_supertaxa = TRUE, collapse_func = mean, ...)}
}
\examples{
sample_frac_obs(ex_taxmap, "info", 0.5)

}
\seealso{
Other taxmap manipulation functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{mutate_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{transmute_obs}}
}
