% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_destroy.R
\name{tar_destroy}
\alias{tar_destroy}
\title{Destroy the data store.}
\usage{
tar_destroy(
  destroy = c("all", "cloud", "local", "meta", "process", "progress", "objects",
    "scratch", "workspaces", "user"),
  ask = NULL,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{destroy}{Character of length 1, what to destroy. Choices:
\itemize{
\item \code{"all"}: destroy the entire data store (default: \verb{_targets/})
including cloud data.
\item \code{"cloud"}: just try to delete cloud data, e.g. target data
from targets with \code{tar_target(..., repository = "aws")}.
\item \code{"local"}: all the local files in the data store but nothing
on the cloud.
\item \code{"meta"}: just delete the metadata file at \code{meta/meta} in the
data store, which invalidates all the targets but keeps the data.
\item \code{"process"}: just delete the progress data file at
\code{meta/process} in the data store, which resets the metadata
of the main process.
\item \code{"progress"}: just delete the progress data file at
\code{meta/progress} in the data store,
which resets the progress tracking info.
\item \code{"objects"}: delete all the target
return values in \verb{objects/} in the data
store but keep progress and metadata.
Dynamic files are not deleted this way.
\item \code{"scratch"}: temporary files saved during \code{\link[=tar_make]{tar_make()}} that should
automatically get deleted except if R crashed.
\item \code{"workspaces"}: compressed lightweight files in \verb{workspaces/}
in the data store with the saved workspaces of targets.
See \code{\link[=tar_workspace]{tar_workspace()}} for details.
\item \code{"user"}: custom user-supplied files in the \verb{user/} folder in the
data store.
}}

\item{ask}{Logical of length 1, whether to pause with a menu prompt
before deleting files. To disable this menu, set the \code{TAR_ASK}
environment variable to \code{"false"}. \code{usethis::edit_r_environ()}
can help set environment variables.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Destroy the data store written by the pipeline.
}
\details{
The data store is a folder created by \code{\link[=tar_make]{tar_make()}}
(or \code{\link[=tar_make_future]{tar_make_future()}} or \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}).
The details of the data store are explained at
\url{https://books.ropensci.org/targets/data.html#local-data-store}.
The data store folder contains the output data
and metadata of the targets in the pipeline. Usually,
the data store is a folder called \verb{_targets/}
(see \code{\link[=tar_config_set]{tar_config_set()}} to customize), and it may
link to data on the cloud if you used AWS or GCP
buckets. By default, \code{tar_destroy()} deletes the entire
\verb{_targets/} folder (or wherever the data store is located),
including custom user-supplied files in \verb{_targets/user/},
as well as any cloud data that the pipeline uploaded.
See the \code{destroy} argument to customize this behavior
and only delete part of the data store, and see functions like
\code{\link[=tar_invalidate]{tar_invalidate()}}, \code{\link[=tar_delete]{tar_delete()}}, and \code{\link[=tar_prune]{tar_prune()}} to remove
information pertaining to some but not all targets in the pipeline.
After calling \code{tar_destroy()} with default arguments,
the entire data store is gone, which means all the output data from
previous runs of the pipeline is gone (except for
input/output files tracked with \code{tar_target(..., format = "file")}).
The next run of the pipeline will start from scratch,
and it will not skip any targets.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(list(tar_target(x, 1 + 1)), ask = FALSE)
tar_make() # Creates the _targets/ data store.
tar_destroy()
print(file.exists("_targets")) # Should be FALSE.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune}()}
}
\concept{clean}
