% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_destroy.R
\name{tar_destroy}
\alias{tar_destroy}
\title{Destroy all or part of the data store.}
\usage{
tar_destroy(
  destroy = c("all", "meta", "process", "progress", "objects", "scratch", "workspaces")
)
}
\arguments{
\item{destroy}{Character of length 1, what to destroy. Choices:
\itemize{
\item \code{"all"}: destroy the entire data store.
\item \code{"meta"}: just delete the metadata file at \verb{_targets/meta/meta},
which invalidates all the targets but keeps the data.
\item \code{"process"}: just delete the progress data file at
\verb{_targets/meta/process}, which resets the metadata
of the main process.
\item \code{"progress"}: just delete the progress data file at
\verb{_targets/meta/progress}, which resets the progress tracking info.
\item \code{"objects"}: delete all the target return values in \verb{_targets/objects/}
but keep progress and metadata. Dynamic files are not deleted this way.
\item \code{"scratch"}: temporary files saved during \code{\link[=tar_make]{tar_make()}} that should
automatically get deleted except if R crashed.
\item \code{"workspaces"}: compressed files in \verb{_targets/workspaces/} with
the saved workspaces of targets that errored. Only saved
if \code{error = "workspace"} in \code{\link[=tar_option_set]{tar_option_set()}} or \code{\link[=tar_target]{tar_target()}}.
Load a workspace with \code{\link[=tar_workspace]{tar_workspace()}}.
}}
}
\value{
Nothing.
}
\description{
Destroy all or part of the data store written
by \code{\link[=tar_make]{tar_make()}} and similar functions.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)), ask = FALSE)
tar_make() # Creates the _targets/ data store.
tar_destroy()
print(file.exists("_targets")) # Should be FALSE.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune}()}
}
\concept{clean}
