% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncatedscore.R
\name{estimate_truncatedscore}
\alias{estimate_truncatedscore}
\title{Estimation of mean clinical outcome truncated by event process}
\usage{
estimate_truncatedscore(
  data,
  mod.y,
  mod.r,
  mod.a,
  mod.event,
  time,
  cause = NULL,
  cens.code = 0,
  naive = FALSE,
  control = list(),
  ...
)
}
\arguments{
\item{data}{(data.frame)}

\item{mod.y}{(formula or learner) Model for clinical outcome given T>time.
Using a formula specifies a glm with an identity link (see example).}

\item{mod.r}{(formula or learner) Model for missing data mechanism for
clinical outcome at T=time. Using a formula specifies a glm with a log
link.}

\item{mod.a}{(formula or learner) Treatment model (in RCT should just be 'a
~ 1'). Using a formula specifies a glm with a log link.}

\item{mod.event}{(formula) Model for time-to-event process
('Event(time,status) ~ x').}

\item{time}{(numeric) Landmark time.}

\item{cause}{(integer) Primary event (in the 'status' variable of the 'Event'
statement).}

\item{cens.code}{(integer) Censoring code.}

\item{naive}{(logical) If TRUE, the unadjusted estimates ignoring baseline
covariates is returned as the attribute 'naive'.}

\item{control}{(list) optimization routine parameters.}

\item{...}{Additional arguments passed to \link[mets:binregATE]{mets::binregATE}.}
}
\value{
\link[lava:estimate.default]{lava::estimate.default} object
}
\description{
Let \eqn{Y} denote the clinical outcome, \eqn{A} the binary treatment
variable, \eqn{X} baseline covariates, \eqn{T} the failure time,
and \eqn{epsilon=1,2} the cause of failure.
The following are our two target parameters
\deqn{E(Y|T>t, A=1)- E(Y|T>t, A=0)}
\deqn{P(T<t,\epsilon=1|A=1)- P(T<t,\epsilon=1|A=0)}
}
\examples{
data(truncatedscore)
mod1 <- learner_glm(y ~ a * (x1 + x2))
mod2 <- learner_glm(r ~ a * (x1 + x2), family = binomial)
a <- estimate_truncatedscore(
  data = truncatedscore,
  mod.y = mod1,
  mod.r = mod2,
  mod.a = a ~ 1,
  mod.event = mets::Event(time, status) ~ x1+x2,
  time = 2
)
s <- summary(a, noninf.t = -0.1)
print(s)
parameter(s)

# the above is equivalent to
# a <- estimate_truncatedscore(
#   data = truncatedscore,
#   mod.y = y ~ a * (x1 + x2),
#   mod.r = r ~ a * (x1 + x2),
#   mod.a = a ~ 1,
#   mod.event = mets::Event(time, status) ~ x1+x2,
#   time = 2
# )
}
\author{
Klaus Kähler Holst
}
