% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NB.R
\name{NB}
\alias{NB}
\alias{NB2}
\title{Naive Bayes}
\usage{
NB(
  formula,
  data,
  weights = NULL,
  kernel = FALSE,
  laplace.smooth = 0,
  prior = NULL,
  ...
)
}
\arguments{
\item{formula}{Formula with syntax: response ~ predictors | weights}

\item{data}{data.frame}

\item{weights}{optional frequency weights}

\item{kernel}{If TRUE a kernel estimator is used for numeric predictors (otherwise a gaussian model is used)}

\item{laplace.smooth}{Laplace smoothing}

\item{prior}{optional prior probabilities (default estimated from data)}

\item{...}{additional arguments to lower level functions}
}
\value{
An object of class '\code{NB}' is returned. See
  \code{\link{NB-class}} for more details about this class and
  its generic functions.
}
\description{
Naive Bayes Classifier
}
\examples{
data(iris)
m2 <- NB(Species ~ Sepal.Width + Petal.Length, data=iris)
pr2 <- predict(m2, newdata=iris)
}
\author{
Klaus K. Holst
}
