% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAPPA.r
\name{TAPPA}
\alias{TAPPA}
\title{Title  Tangent area proportional method TAPPA}
\usage{
TAPPA(T, dAlpha, interval = 10, tol = 0.001)
}
\arguments{
\item{T}{temperature}

\item{dAlpha}{the da/dt values}

\item{interval}{number of points to use for interpolating the two lines that will merge according to the area of the peak}

\item{tol}{tollerance for the iterative process}
}
\value{
B baseline values
}
\description{
calculates the background of a thermogram according to Tangent-area-proportional method
}
\examples{
npoints=1000
x=seq(1,npoints)
y=(dnorm(seq(1,npoints), mean=npoints/2, sd=npoints/10)) #simulated peak
y2=y+(dnorm(seq(1,npoints), mean=npoints, sd=npoints/10)) #secondary simulated peak
y2[seq(npoints*0.735,npoints)]=y2[763] #flat the curve at the end of first peak
ytap=TAPPA(x,y2)
plot(x,y2)
lines(x,ytap,col="red")
}
\references{
1. Svoboda R. Tangential area-proportional baseline interpolation for complex-process DSC data - Yes or no? Thermochim Acta. 2017;658:55-62. doi:10.1016/J.TCA.2017.10.011.2. Svoboda R. Linear baseline interpolation for single-process DSC data-Yes or no? Thermochim Acta. 2017;655:242-250. doi:10.1016/J.TCA.2017.07.008.
}
