% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{set_confirm}
\alias{set_confirm}
\title{Set confirmation prompt for deleting objects}
\usage{
set_confirm(confirm = NULL)
}
\arguments{
\item{confirm}{A logical value indimessageing whether to prompt for confirmation before deleting objects. If \code{TRUE}, a confirmation prompt will be displayed. If \code{FALSE}, no confirmation prompt will be displayed. If \code{NULL}, the current setting will be returned without changing it.}
}
\value{
If \code{confirm} is \code{NULL}, the current setting for the confirmation prompt is returned. Otherwise, the confirmation prompt setting is updated.
}
\description{
This function sets the confirmation prompt for the \code{\link{rm_bytag}} function
when deleting objects with a specified tag.
}
\examples{
# turn on confirmation prompt
set_confirm(TRUE)

# turn off confirmation prompt
set_confirm(FALSE)

# get current confirmation prompt setting
set_confirm()

}
