% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_similarity.R
\docType{methods}
\name{similarity}
\alias{similarity}
\alias{similarity-method}
\alias{index_jaccard}
\alias{index_jaccard-method}
\alias{index_sorenson}
\alias{index_sorenson-method}
\alias{index_bray}
\alias{index_bray-method}
\alias{index_morisita}
\alias{index_morisita-method}
\alias{index_brainerd}
\alias{index_brainerd-method}
\alias{index_binomial}
\alias{index_binomial-method}
\alias{similarity,matrix-method}
\alias{similarity,data.frame-method}
\alias{index_jaccard,character,character-method}
\alias{index_jaccard,logical,logical-method}
\alias{index_jaccard,numeric,numeric-method}
\alias{index_sorenson,logical,logical-method}
\alias{index_sorenson,numeric,numeric-method}
\alias{index_bray,numeric,numeric-method}
\alias{index_morisita,numeric,numeric-method}
\alias{index_brainerd,numeric,numeric-method}
\alias{index_binomial,numeric,numeric-method}
\title{Similarity}
\usage{
similarity(object, ...)

index_jaccard(x, y, ...)

index_sorenson(x, y, ...)

index_bray(x, y, ...)

index_morisita(x, y, ...)

index_brainerd(x, y, ...)

index_binomial(x, y, ...)

\S4method{similarity}{matrix}(
  object,
  method = c("brainerd", "bray", "jaccard", "morisita", "sorenson", "binomial")
)

\S4method{similarity}{data.frame}(
  object,
  method = c("brainerd", "bray", "jaccard", "morisita", "sorenson", "binomial")
)

\S4method{index_jaccard}{character,character}(x, y)

\S4method{index_jaccard}{logical,logical}(x, y)

\S4method{index_jaccard}{numeric,numeric}(x, y)

\S4method{index_sorenson}{logical,logical}(x, y)

\S4method{index_sorenson}{numeric,numeric}(x, y)

\S4method{index_bray}{numeric,numeric}(x, y)

\S4method{index_morisita}{numeric,numeric}(x, y)

\S4method{index_brainerd}{numeric,numeric}(x, y)

\S4method{index_binomial}{numeric,numeric}(x, y)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Currently not used.}

\item{x, y}{A length-\eqn{p} \code{\link{numeric}} vector of count data.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}
}
\value{
\itemize{
\item \code{similarity()} returns a \link[stats:dist]{stats::dist} object.
\item \verb{index_*()} return a \code{\link{numeric}} vector.
}
}
\description{
Similarity
}
\details{
\eqn{\beta}-diversity can be measured by addressing \emph{similarity}
between pairs of samples/cases (Brainerd-Robinson, Jaccard, Morisita-Horn
and Sorenson indices). Similarity between pairs of taxa/types can be
measured by assessing the degree of co-occurrence (binomial co-occurrence).

Jaccard, Morisita-Horn and Sorenson indices provide a scale of similarity
from \eqn{0}-\eqn{1} where \eqn{1} is perfect similarity and \eqn{0} is
no similarity. The Brainerd-Robinson index is scaled between \eqn{0} and
\eqn{200}. The Binomial co-occurrence assessment approximates a Z-score.

\describe{
\item{\code{binomial}}{Binomial co-occurrence assessment. This assesses the
degree of co-occurrence between taxa/types within a dataset. The strongest
associations are shown by large positive numbers, the strongest
segregations by large negative numbers.}
\item{\code{brainerd}}{Brainerd-Robinson quantitative index. This is a
city-block metric of similarity between pairs of samples/cases.}
\item{\code{bray}}{Sorenson quantitative index (Bray and Curtis modified version
of the Sorenson index).}
\item{\code{jaccard}}{Jaccard qualitative index.}
\item{\code{morisita}}{Morisita-Horn quantitative index.}
\item{\code{sorenson}}{Sorenson qualitative index.}
}
}
\examples{
## Data from Huntley 2004, 2008
data("pueblo")

## Brainerd-Robinson measure
(C <- similarity(pueblo, "brainerd"))
plot_spot(C)

## Data from Magurran 1988, p. 166
data("aves")

## Jaccard measure (presence/absence data)
similarity(aves, "jaccard") # 0.46

## Sorenson measure (presence/absence data)
similarity(aves, "sorenson") # 0.63

# Jaccard measure (Bray's formula ; count data)
similarity(aves, "bray") # 0.44

# Morisita-Horn measure (count data)
similarity(aves, "morisita") # 0.81
}
\references{
Brainerd, G. W. (1951). The Place of Chronological Ordering in
Archaeological Analysis. \emph{American Antiquity}, 16(04), 301-313.
\doi{10.2307/276979}.

Bray, J. R. & Curtis, J. T. (1957). An Ordination of the Upland Forest
Communities of Southern Wisconsin. \emph{Ecological Monographs}, 27(4),
325-349. \doi{10.2307/1942268}.

Kintigh, K. (2006). Ceramic Dating and Type Associations. In J. Hantman and
R. Most (eds.), \emph{Managing Archaeological Data: Essays in Honor of
Sylvia W. Gaines}. Anthropological Research Paper, 57. Tempe, AZ: Arizona
State University, p. 17-26.

Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.

Robinson, W. S. (1951). A Method for Chronologically Ordering Archaeological
Deposits. \emph{American Antiquity}, 16(04), 293-301. \doi{10.2307/276978}.
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
