% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_turnover.R
\docType{methods}
\name{turnover-index}
\alias{turnover-index}
\alias{turnover}
\alias{turnover-method}
\alias{turnover,CountMatrix-method}
\alias{turnover,IncidenceMatrix-method}
\title{Turnover}
\usage{
turnover(object, ...)

\S4method{turnover}{CountMatrix}(
  object,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson"),
  simplify = FALSE,
  ...
)

\S4method{turnover}{IncidenceMatrix}(
  object,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson"),
  simplify = FALSE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}

\item{simplify}{A \code{\link{logical}} scalar: should the result be
simplified to a matrix?}
}
\value{
If \code{simplify} is \code{FALSE}, returns a \code{\link{list}} (default), else returns a
\code{\link{matrix}}.
}
\description{
Returns the degree of turnover in taxa composition along a gradient or
transect.
}
\details{
The following methods can be used to ascertain the degree of \emph{turnover}
in taxa composition along a gradient (\eqn{\beta}-diversity) on qualitative
(presence/absence) data. This assumes that the order of the matrix rows
(from \eqn{1} to \eqn{n}) follows the progression along the
gradient/transect.

\describe{
\item{\code{whittaker}}{Whittaker measure.}
\item{\code{cody}}{Cody measure.}
\item{\code{routledge1}}{Routledge first measure.}
\item{\code{routledge2}}{Routledge second measure.}
\item{\code{routledge3}}{Routledge third measure. This is the exponential form
of the second measure.}
\item{\code{wilson}}{Wilson measure.}
}
}
\examples{
## Data from Magurran 1988, p. 162
trees <- IncidenceMatrix(
  data = c(1, 1, 1, 0, 0, 0,
           1, 1, 1, 1, 1, 1,
           0, 0, 1, 0, 1, 0,
           0, 0, 0, 1, 1, 1,
           0, 0, 0, 0, 1, 1,
           0, 0, 0, 1, 0, 1),
  nrow = 6, byrow = FALSE,
  dimnames = list(c("1", "2", "3", "4", "5", "6"),
                  c("Birch", "Oak", "Rowan", "Beech", "Hazel", "Holly"))
)

## Whittaker's measure
turnover(trees, "whittaker") # 1

## Cody's measure
turnover(trees, "cody") # 3

## Routledge's measures
turnover(trees, method = c("routledge1", "routledge2", "routledge3"),
         simplify = TRUE) ## 0.29 0.56 1.75

## Wilson and Shmida's measure
turnover(trees, "wilson") # 1
}
\references{
Cody, M. L. (1975). Towards a theory of continental species diversity: Bird
distributions over Mediterranean habitat gradients. \emph{In} M. L. Cody &
J. M. Diamond (Eds.), \emph{Ecology and Evolution of Communities}.
Cambridge, MA: Harvard University Press, p. 214-257.

Routledge, R. D. (1977). On Whittaker's Components of Diversity.
\emph{Ecology}, 58(5), 1120-1127. \doi{10.2307/1936932}.

Whittaker, R. H. (1960). Vegetation of the Siskiyou Mountains, Oregon and
California. \emph{Ecological Monographs}, 30(3), 279-338.
\doi{10.2307/1943563}.

Wilson, M. V., & Shmida, A. (1984). Measuring Beta Diversity with
Presence-Absence Data. \emph{The Journal of Ecology}, 72(3), 1055-1064.
\doi{10.2307/2259551}.
}
\seealso{
Other diversity: 
\code{\link{heterogeneity-index}},
\code{\link{richness-index}},
\code{\link{similarity}()}
}
\author{
N. Frerebeau
}
\concept{diversity}
